SuperStrict

' Example 9: Error Handling
' Demonstrates: Checking return codes and handling errors

Framework BRL.StandardIO

Import "-L."
Import "-lBlitzSpeech"
Include "BlitzSpeechH.bmx"

Print "BlitzSpeech - Error Handling Example"

Print ""

' Test initialization
Print "Testing initialization..."
Local result:Int = InitSpeech()
If result = SP_INIT_SUCCESS Then
    Print "  SUCCESS: Initialized"
ElseIf result = SP_INIT_ERR_COM_FAILED Then
    Print "  ERROR: COM initialization failed"
    End
ElseIf result = SP_INIT_ERR_VOICE_FAILED Then
    Print "  ERROR: Failed to create voice instance"
    End
End If
Print ""

' Test speaking with error checking
Print "Testing speech..."
result = SpeakText("Hello world")
If result = SP_SPEAK_SUCCESS Then
    Print "  SUCCESS: Speech complete"
ElseIf result = SP_SPEAK_ERR_NOT_INIT Then
    Print "  ERROR: Speech not initialized"
ElseIf result = SP_SPEAK_ERR_NULL_TEXT Then
    Print "  ERROR: NULL text pointer"
ElseIf result = SP_SPEAK_ERR_FAILED Then
    Print "  ERROR: Speech failed"
End If
Print ""

' Test invalid voice index
Print "Testing invalid voice index..."
result = SetSpeechVoice(9999)
If result = SP_SET_VOICE_SUCCESS Then
    Print "  SUCCESS: Voice set"
ElseIf result = SP_SET_VOICE_ERR_NOT_INIT Then
    Print "  ERROR: Not initialized"
ElseIf result = SP_SET_VOICE_ERR_BAD_INDEX Then
    Print "  ERROR: Invalid voice index (expected!)"
ElseIf result = SP_SET_VOICE_ERR_FAILED Then
    Print "  ERROR: SetVoice failed"
End If
Print ""

' Test non-existent file
Print "Testing non-existent file..."
result = SpeakFile("does_not_exist.txt")
If result = SP_FILE_SUCCESS Then
    Print "  SUCCESS: File spoken"
ElseIf result = SP_FILE_ERR_CANT_OPEN Then
    Print "  ERROR: File not found (expected!)"
ElseIf result = SP_FILE_ERR_TOO_LARGE Then
    Print "  ERROR: File too large or empty"
End If
Print ""

' Test voice search that won't find anything
Print "Testing voice search for non-existent voice..."
result = SetSpeechVoiceByName("NonExistentVoiceName123")
If result >= 0 Then
    Print "  SUCCESS: Voice found at index " + result
ElseIf result = SP_SET_NAME_ERR_NOT_FOUND Then
    Print "  ERROR: Voice not found (expected!)"
End If
Print ""

CleanupSpeech()
Print "Done! Error handling working correctly."
